<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Certification extends Model 
{

    protected $table = 'certifications';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('certifiable_id', 'certifiable_type', 'reason', 'status', 'id_user');
    protected $visible = array('certifiable_id', 'certifiable_type', 'reason', 'status', 'id_user');

    public function certifiable()
    {
        return $this->morphTo();
    }

}